package com.biz.crm.nebular.mdm.productlevel.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 返回vo
 *
 * @author Liao.Hua
 * @date 2020-09-01 14:13:56
 */
@Data
@ApiModel(value = "产品层级树")
@SaturnEntity(name = "MdmProductLevelTreeRespVo", description = "产品层级树")
public class MdmProductLevelTreeRespVo {

    @SaturnColumn(description = "id")
    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("层级等级查询用")
    @SaturnColumn(description = "层级等级查询用")
    private Integer levelNum;

    @ApiModelProperty("父级产品ID")
    @SaturnColumn(description = "父级产品ID")
    private String parentId;

    @ApiModelProperty("产品层级编码")
    @SaturnColumn(description = "产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    @SaturnColumn(description = "产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品层级类型")
    @SaturnColumn(description = "产品层级类型")
    private String productLevelType;

    @ApiModelProperty("下级产品层级")
    @SaturnColumn(description = "下级产品层级")
    @SaturnColumnRelation(type= SaturnColumnRelation.RelationType.OneToMany)
    private List<MdmProductLevelTreeRespVo> children;

}
