package com.biz.crm.nebular.sfa.assistant.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 工作任务(接收) 请求vo
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkTaskReceveReqVo", description = "工作任务(接收) ")
public class SfaWorkTaskReceveReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("任务id")
    private String taskId;

    @ApiModelProperty("接收人姓名")
    private String receverName;

    @ApiModelProperty("接收人账号")
    private String receverCode;

    @ApiModelProperty("接收人组织编码")
    private String receverOrgCode;

    @ApiModelProperty("接收人组织名称")
    private String receverOrgName;

    @ApiModelProperty("接收人职位编码")
    private String receverPosCode;

    @ApiModelProperty("接收人职位名称")
    private String receverPosName;

    @ApiModelProperty("接收时间")
    private String receveDate;

    @ApiModelProperty("执行时定位地址")
    private String address;

    @ApiModelProperty("执行总结")
    private String summary;

    @ApiModelProperty("执行状态")
    private String executeStatus;

}