package com.biz.crm.nebular.sfa.clientsellpower.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 经销商/终端产品经销权 返回vo
 *
 * @author liuhongming
 * @date 2020-09-24 14:13:28
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "经销商/终端产品经销权 ")
@SaturnEntity(name = "SfaClientSellPowerRespVo", description = "经销商/终端产品经销权 ")
public class SfaClientSellPowerRespVo extends CrmExtVo {
    @ApiModelProperty("经销权编码 经销权编码")
    @SaturnColumn(description = "经销权编码 经销权编码")
    private String tspCode;

    @ApiModelProperty("客户类型 客户类型(01:经销商;02:终端;)")
    @SaturnColumn(description = "客户类型 客户类型(01:经销商;02:终端;)")
    private String clientType;


    @ApiModelProperty("经销商/终端产品经销权可购商品")
    @SaturnColumn(description = "经销商/终端产品经销权可购商品")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaClientSellProductRespVo> sfaClientSellProductRespVos;

    @ApiModelProperty("经销商/终端产品经销权范围")
    @SaturnColumn(description = "经销商/终端产品经销权范围")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaClientSellRangeRespVo> sfaClientSellRangeRespVos;
}