package com.biz.crm.nebular.sfa.visitnote.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 拜访计划制定范围表 请求vo
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitPlanRangeReqVo", description = "拜访计划制定范围表 ")
public class SfaVisitPlanRangeReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("线路组id 线路组id")
    private String visitGroupId;

    @ApiModelProperty("线路组名称 线路组名称")
    private String visitGroupName;

    @ApiModelProperty("网点id 网点id")
    private String clientId;

    @ApiModelProperty("网点编码 网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称 网点名称")
    private String clientName;

    @ApiModelProperty("网点类型 网点类型")
    private String clientType;

    @ApiModelProperty("首次拜访日期 首次拜访日期(yyyy-MM-dd)")
    private String firstVisitDate;

    @ApiModelProperty("拜访频率 拜访频率（天/1次）")
    private Integer visitFrequency;

    @ApiModelProperty("拜访计划编码 拜访计划编码")
    private String visitPlanCode;

    @ApiModelProperty("拜访计划制定编码集合")
    private List<String> visitPlanCodes;
}