package com.biz.crm.nebular.sfa.visitstep.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 拜访步骤(订单主表);返回vo
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访步骤(订单主表);")
@SaturnEntity(name = "SfaVisitStepOrderRespVo", description = "拜访步骤(订单主表);")
public class SfaVisitStepOrderRespVo extends CrmExtVo {

    @ApiModelProperty("拜访编码")
    @SaturnColumn(description = "拜访编码")
    private String visitId;

    @ApiModelProperty("网点id")
    @SaturnColumn(description = "网点id")
    private String clientId;

    @ApiModelProperty("网点编码")
    @SaturnColumn(description = "网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    @SaturnColumn(description = "网点名称")
    private String clientName;

    @ApiModelProperty("上级客户编码")
    @SaturnColumn(description = "上级客户编码")
    private String customerCode;

    @ApiModelProperty("上级客户名称")
    @SaturnColumn(description = "上级客户名称")
    private String customerName;

    @ApiModelProperty("联系人")
    @SaturnColumn(description = "联系人")
    private String contacts;

    @ApiModelProperty("联系电话")
    @SaturnColumn(description = "联系电话")
    private String telephone;

    @ApiModelProperty("收货地址")
    @SaturnColumn(description = "收货地址")
    private String address;

    @ApiModelProperty("期望收货时间")
    @SaturnColumn(description = "期望收货时间")
    private String expectReceive;

    @ApiModelProperty("产品明细列表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    @SaturnColumn(description = "产品明细列表")
    private List<SfaVisitStepOrderItemRespVo> sfaVisitStepOrderItemRespVos;

}