package com.biz.crm.nebular.mdm.coderule.resp;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 编码规则返回vo
 *
 * @author Tao.Chen
 * @date 2020-11-05 10:47:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "编码规则")
@SaturnEntity(name = "MdmCodeRuleRespVo", description = "编码规则")
public class MdmCodeRuleRespVo extends UuidVo {

    @ApiModelProperty("业务key")
    @SaturnColumn(description = "业务key")
    private String ruleCode;

    @ApiModelProperty("前缀")
    @SaturnColumn(description = "前缀")
    private String prefix;

    @ApiModelProperty("时间格式")
    @SaturnColumn(description = "时间格式")
    private String dateFormat;

    @ApiModelProperty("长度")
    @SaturnColumn(description = "长度")
    private Integer codeLength;

    @ApiModelProperty("规则描述")
    @SaturnColumn(description = "规则描述")
    private String ruleDescription;

    @ApiModelProperty("起始值")
    @SaturnColumn(description = "起始值")
    private Integer initialValue;

    @ApiModelProperty("当前值")
    @SaturnColumn(description = "当前值")
    private Integer currentValue;

}