package com.biz.crm.nebular.mdm.dict.resp;

import com.biz.crm.nebular.mdm.PageVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 数据字典扩展字段配置表返回vo
 *
 * @author Tao.Chen
 * @date 2020-10-30 10:46:50
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "数据字典扩展字段配置表")
@SaturnEntity(name = "EngineDictAttrConfRespVo", description = "数据字典扩展字段配置表")
public class EngineDictAttrConfRespVo extends PageVo {
    @ApiModelProperty("数据字典类型编码")
    @SaturnColumn(description = "数据字典类型编码")
    private String dictTypeCode;

    @ApiModelProperty("字段编码")
    @SaturnColumn(description = "字段编码")
    private String fieldCode;

    @ApiModelProperty("字段名称")
    @SaturnColumn(description = "字段名称")
    private String fieldName;

    @ApiModelProperty("是否必填")
    @SaturnColumn(description = "是否必填")
    private String required;

    @ApiModelProperty("显示顺序")
    @SaturnColumn(description = "显示顺序")
    private Integer showOrder;

    @ApiModelProperty("扩展属性字段")
    @SaturnColumn(description = "扩展属性字段")
    private String extField;

    @ApiModelProperty("下拉框数据字典")
    @SaturnColumn(description = "下拉框数据字典")
    private String selectDictType;

    @ApiModelProperty("数据字典类型ID")
    @SaturnColumn(description = "数据字典类型ID")
    private String dictEntityId;
}