package com.biz.crm.nebular.mdm.dict.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 字典明细列表表头返回vo
 *
 * @author Tao.Chen
 * @date 2020-10-26 16:47:25
 */
@Data
@Builder
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "字典明细项列表表头")
@SaturnEntity(name = "EngineDictItemListHeadRespVo", description = "字典明细项列表表头")
public class EngineDictItemListHeadRespVo {

    @ApiModelProperty("字段编码")
    @SaturnColumn(description = "字段编码")
    private String fieldCode;

    @ApiModelProperty("字段名称")
    @SaturnColumn(description = "字段名称")
    private String fieldName;

    @ApiModelProperty("是否必填")
    @SaturnColumn(description = "是否必填")
    private String required;
}