package com.biz.crm.nebular.mdm.humanarea;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 一个拥有权限信息的业务系统用户定义返回vo
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "一个拥有权限信息的业务系统用户定义")
@SaturnEntity(name = "EngineUserRespVo", description = "一个拥有权限信息的业务系统用户定义")
public class EngineUserRespVo extends CrmBaseVo {

    @ApiModelProperty("用户编码")
    @SaturnColumn(description = "用户编码")
    private String userCode;

    @ApiModelProperty("用户账号登录信息")
    @SaturnColumn(description = "用户账号登录信息")
    private String userAccount;

    @ApiModelProperty("性别.0保密，1男 2女")
    @SaturnColumn(description = "性别.0保密，1男 2女")
    private Integer gender;

    @ApiModelProperty("用户账号密码信息（经过加密的）")
    @SaturnColumn(description = "用户账号密码信息（经过加密的）")
    private String userPassword;

    @ApiModelProperty("人员主要联系电话(也可能会使用该信息登录)")
    @SaturnColumn(description = "人员主要联系电话(也可能会使用该信息登录)")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    @SaturnColumn(description = "人员姓名")
    private String userName;

    @ApiModelProperty("用户类型,u：企业用户，c：客户用户,数据字典user_type")
    @SaturnColumn(description = "用户类型，u：企业用户，c：客户用户,数据字典user_type")
    private String userType;

    @ApiModelProperty("用户类型名称")
    @SaturnColumn(description = "用户类型名称")
    @CrmDict(typeCode = DictConstant.USER_TYPE,dictCodeField = "userType")
    private String userTypeName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String positionName;

    @ApiModelProperty("职位级别编码")
    @SaturnColumn(description = "职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("职位级别名称")
    @SaturnColumn(description = "职位级别名称")
    private String positionLevelName;

    @ApiModelProperty("上级用户名称")
    @SaturnColumn(description = "上级用户名称")
    private String parentUserName;

    @ApiModelProperty("上级用户帐号")
    @SaturnColumn(description = "上级用户帐号")
    private String parentUserAccount;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("锁定状态")
    @SaturnColumn(description = "锁定状态009正常，003锁定")
    private String lockState;

    @ApiModelProperty("锁定状态名称")
    @SaturnColumn(description = "锁定状态名称")
    private String lockStateName;

    @ApiModelProperty("token")
    @SaturnColumn(description = "token")
    private String token;

    @ApiModelProperty("角色编码")
    @SaturnColumn(description = "角色编码")
    private String roleCode;

    @ApiModelProperty("角色名称")
    @SaturnColumn(description = "角色编码")
    private String roleName;

    @ApiModelProperty("客户用户角色编码")
    @SaturnColumn(description = "客户用户角色编码")
    private String customerRoleCode;

    @ApiModelProperty("客户用户角色名称")
    @SaturnColumn(description = "客户用户角色名称")
    private String customerRoleName;

}