package com.biz.crm.nebular.mdm.material;
import com.biz.crm.config.CrmDict;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 返回vo
 *
 * @author zxw
 * @date 2020-09-01 19:55:17
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "物料管理响应")
@Data
@SaturnDomain(value = "mdmmaterialrespvo")
@SaturnEntity(name = "MdmMaterialRespVo", description = "物料管理响应")
public class MdmMaterialRespVo extends CrmTreeVo {

    @ApiModelProperty("产品层级编码")
    @SaturnColumn(description = "产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("物料编码")
    @SaturnColumn(description = "物料编码")
    private String materialCode;

    @ApiModelProperty("物料名称")
    @SaturnColumn(description = "物料名称")
    private String materialName;

    @ApiModelProperty("产品层级名称")
    @SaturnColumn(description = "产品层级名称")
    private String productLevelName;

    @ApiModelProperty("AI编码")
    @SaturnColumn(description = "AI编码")
    private String aiCode;

    @ApiModelProperty("条形码")
    @SaturnColumn(description = "条形码")
    private String barCode;

    @ApiModelProperty("基本单位")
    @SaturnColumn(description = "基本单位")
    private String baseUnit;

    @ApiModelProperty("基本单位")
    @SaturnColumn(description = "基本单位")
    @CrmDict(typeCode = "material_base_unit",dictCodeField = "baseUnit")
    private String baseUnitName;

    @ApiModelProperty("物料类型")
    @SaturnColumn(description = "物料类型")
    private String materialType;

    @ApiModelProperty("物料类型")
    @SaturnColumn(description = "物料类型名称")
    @CrmDict(typeCode = "material_type",dictCodeField = "materialType")
    private String materialTypeName;

    @ApiModelProperty("销售公司")
    @SaturnColumn(description = "销售公司")
    private String saleCompany;

    @ApiModelProperty("销售公司")
    @SaturnColumn(description = "销售公司名称")
    @CrmDict(typeCode = "sale_company",dictCodeField = "saleCompany")
    private String saleCompanyName;

    @ApiModelProperty("销售单位")
    @SaturnColumn(description = "销售单位")
    private String saleUnit;

    @ApiModelProperty("销售单位")
    @SaturnColumn(description = "销售单位名称")
    @CrmDict(typeCode = "material_sale_unit",dictCodeField = "saleUnit")
    private String saleUnitName;

    @ApiModelProperty("规格")
    @SaturnColumn(description = "规格")
    private String specification;

    @ApiModelProperty("单位换算系数")
    @SaturnColumn(description = "单位换算系数")
    private String unitConversion;

    @ApiModelProperty("成本价格")
    @SaturnColumn(description = "成本价格")
    private String costPrice;
}