package com.biz.crm.nebular.mdm.region;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.PageVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 行政区域信息请求vo
 *
 * @author zxw
 * @date 2020-09-29 10:35:57
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "EngineAdministrativeRegionReqVo", description = "行政区域信息")
public class EngineAdministrativeRegionReqVo extends CrmTreeVo {

    @ApiModelProperty("id集合")
    private List<String> ids;

    @ApiModelProperty("降维编码")
    private String dimensionalityCode;

    @ApiModelProperty("邮编")
    private String email;

    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("区域编码")
    private String regionCode;

    @ApiModelProperty("区域层级")
    private String regionLevel;

    @ApiModelProperty("区域名称")
    private String regionName;

    @ApiModelProperty("父级组织")
    private String parentId;

    @ApiModelProperty("传入当前区域层级,查询上级区域层级数据")
    private String currentRegionLevel;

    @ApiModelProperty("上级编码")
    private String parentCode;

}