package com.biz.crm.nebular.mdm.region;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 行政区域信息返回vo
 *
 * @author zxw
 * @date 2020-09-29 10:35:57
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "行政区域信息")
@SaturnEntity(name = "EngineAdministrativeRegionRespVo", description = "行政区域信息")
public class EngineAdministrativeRegionRespVo extends CrmTreeVo {

    @ApiModelProperty("降维编码")
    @SaturnColumn(description = "降维编码")
    private String dimensionalityCode;

    @ApiModelProperty("邮编")
    @SaturnColumn(description = "邮编")
    private String email;

    @ApiModelProperty("纬度")
    @SaturnColumn(description = "纬度")
    private String latitude;

    @ApiModelProperty("经度")
    @SaturnColumn(description = "经度")
    private String longitude;

    @ApiModelProperty("区域编码")
    @SaturnColumn(description = "区域编码")
    private String regionCode;

    @ApiModelProperty("区域层级")
    @SaturnColumn(description = "区域层级")
    private String regionLevel;

    @ApiModelProperty("区域层级名称")
    @SaturnColumn(description = "区域层级名称")
    @CrmDict(typeCode = DictConstant.REGION_LEVEL,dictCodeField = "regionLevel")
    private String regionLevelName;

    @ApiModelProperty("区域名称")
    @SaturnColumn(description = "区域名称")
    private String regionName;

    @ApiModelProperty("上级区域id")
    @SaturnColumn(description = "上级区域id")
    private String parentId;

    @ApiModelProperty("上级区域名称")
    @SaturnColumn(description = "上级区域名称")
    private String parentName;

}