package com.biz.crm.nebular.sfa.worksign.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 考勤打卡记录表 返回vo
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "考勤打卡记录表 ")
@SaturnEntity(name = "SfaWorkSignRecordRespVo", description = "考勤打卡记录表 ")
public class SfaWorkSignRecordRespVo extends CrmExtVo {
    @ApiModelProperty("考勤规则明细表id 考勤规则明细表id")
    @SaturnColumn(description = "考勤规则明细表id 考勤规则明细表id")
    private String wsRuleInfoId;

    @ApiModelProperty("打卡类型 打卡类型（1:上班签到;2:下班签退）")
    @SaturnColumn(description = "打卡类型 打卡类型（1:上班签到;2:下班签退）")
    private String workSignType;

    @ApiModelProperty("打卡类型描述 打卡类型描述")
    @SaturnColumn(description = "打卡类型描述 打卡类型描述")
    private String workSignDesc;

    @ApiModelProperty("考勤时间 考勤时间(HH:mm:ss)")
    @SaturnColumn(description = "考勤时间 考勤时间(HH:mm:ss)")
    private String workSignTime;

    @ApiModelProperty("考勤地点 考勤地点")
    @SaturnColumn(description = "考勤地点 考勤地点")
    private String workSignPlace;

    @ApiModelProperty("打卡经度 打卡经度")
    @SaturnColumn(description = "打卡经度 打卡经度")
    private String lngIn;

    @ApiModelProperty("打卡纬度 打卡纬度")
    @SaturnColumn(description = "打卡纬度 打卡纬度")
    private String latIn;

    @ApiModelProperty("考勤状态 考勤状态(0:未打卡;1:正常;2:迟到;3:早退;)")
    @SaturnColumn(description = "考勤状态 考勤状态(0:未打卡;1:正常;2:迟到;3:早退;)")
    private String workSignStatus;

    @ApiModelProperty("考勤地点状态  考勤地点状态(1:正常;2:异常;)")
    @SaturnColumn(description = "考勤地点状态  考勤地点状态(1:正常;2:异常;)")
    private String wsPlaceStatus;

    @ApiModelProperty("打卡人员id 打卡人员id")
    @SaturnColumn(description = "打卡人员id 打卡人员id")
    private String wsUserId;

    @ApiModelProperty("打卡人员账号 打卡人员账号")
    @SaturnColumn(description = "打卡人员账号 打卡人员账号")
    private String wsUserName;

    @ApiModelProperty("打卡人员名称 打卡人员名称")
    @SaturnColumn(description = "打卡人员名称 打卡人员名称")
    private String wsRealName;

    @ApiModelProperty("打卡职位id 打卡职位id")
    @SaturnColumn(description = "打卡职位id 打卡职位id")
    private String wsPosId;

    @ApiModelProperty("打卡职位编码 打卡职位编码")
    @SaturnColumn(description = "打卡职位编码 打卡职位编码")
    private String wsPosCode;

    @ApiModelProperty("打卡职位名称 打卡职位名称")
    @SaturnColumn(description = "打卡职位名称 打卡职位名称")
    private String wsPosName;

    @ApiModelProperty("打卡组织id 打卡组织id")
    @SaturnColumn(description = "打卡组织id 打卡组织id")
    private String wsOrgId;

    @ApiModelProperty("打卡组织编码 打卡组织编码")
    @SaturnColumn(description = "打卡组织编码 打卡组织编码")
    private String wsOrgCode;

    @ApiModelProperty("打卡组织名称 打卡组织名称")
    @SaturnColumn(description = "打卡组织名称 打卡组织名称")
    private String wsOrgName;

    @ApiModelProperty("考勤照片 考勤照片")
    @SaturnColumn(description = "考勤照片")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaWorkSignPictureRespVo> sfaWorkSignPictureRespVos;

}