package com.biz.crm.nebular.sfa.worksign.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 考勤规则明细表 返回vo
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "考勤规则明细表 ")
@SaturnEntity(name = "SfaWorkSignRuleInfoRespVo", description = "考勤规则明细表 ")
public class SfaWorkSignRuleInfoRespVo extends CrmExtVo {
    @ApiModelProperty("人员id 人员id")
    @SaturnColumn(description = "人员id 人员id")
    private String userId;

    @ApiModelProperty("人员账号 人员账号")
    @SaturnColumn(description = "人员账号 人员账号")
    private String userName;

    @ApiModelProperty("人员名称 人员名称")
    @SaturnColumn(description = "人员名称 人员名称")
    private String realName;

    @ApiModelProperty("职位id 职位id")
    @SaturnColumn(description = "职位id 职位id")
    private String posId;

    @ApiModelProperty("职位编码 职位编码")
    @SaturnColumn(description = "职位编码 职位编码")
    private String posCode;

    @ApiModelProperty("职位名称 职位名称")
    @SaturnColumn(description = "职位名称 职位名称")
    private String posName;

    @ApiModelProperty("组织id 组织id")
    @SaturnColumn(description = "组织id 组织id")
    private String orgId;

    @ApiModelProperty("组织编码 组织编码")
    @SaturnColumn(description = "组织编码 组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称 组织名称")
    @SaturnColumn(description = "组织名称 组织名称")
    private String orgName;

    @ApiModelProperty("规则编码 规则编码")
    @SaturnColumn(description = "规则编码 规则编码")
    private String ruleCode;

    @ApiModelProperty("规则名称 规则名称")
    @SaturnColumn(description = "规则名称 规则名称")
    private String ruleName;

    @ApiModelProperty("规则类型 规则类型（1:固定时间上下班规则/2:自由时间上下班规则/0:自由签到）")
    @SaturnColumn(description = "规则类型 规则类型（1:固定时间上下班规则/2:自由时间上下班规则/0:自由签到）")
    private String ruleType;

    @ApiModelProperty("考勤日期 考勤日期（yyyy-MM-dd）")
    @SaturnColumn(description = "考勤日期 考勤日期（yyyy-MM-dd）")
    private String ruleDate;

    @ApiModelProperty("上班开始时间 上班开始时间(HH:mm:ss)")
    @SaturnColumn(description = "上班开始时间 上班开始时间(HH:mm:ss)")
    private String gotoTime;

    @ApiModelProperty("上班结束时间 上班结束时间(HH:mm:ss)")
    @SaturnColumn(description = "上班结束时间 上班结束时间(HH:mm:ss)")
    private String gooffTime;

    @ApiModelProperty("上班打卡开始时间 上班打卡开始时间(HH:mm:ss)")
    @SaturnColumn(description = "上班打卡开始时间 上班打卡开始时间(HH:mm:ss)")
    private String gotoStartTime;

    @ApiModelProperty("上班打卡结束时间 上班打卡结束时间(HH:mm:ss)")
    @SaturnColumn(description = "上班打卡结束时间 上班打卡结束时间(HH:mm:ss)")
    private String gotoEndTime;

    @ApiModelProperty("下班打卡开始时间 下班打卡开始时间(HH:mm:ss)")
    @SaturnColumn(description = "下班打卡开始时间 下班打卡开始时间(HH:mm:ss)")
    private String gooffStartTime;

    @ApiModelProperty("下班打卡结束时间 下班打卡结束时间(HH:mm:ss)")
    @SaturnColumn(description = "下班打卡结束时间 下班打卡结束时间(HH:mm:ss)")
    private String gooffEndTime;

    @ApiModelProperty("电子围栏 电子围栏(1:允许范围外打卡，地点记录为异常/2:允许范围外打卡，地点记录为正常/3:不允许范围外打卡)")
    @SaturnColumn(description = "电子围栏 电子围栏(1:允许范围外打卡，地点记录为异常/2:允许范围外打卡，地点记录为正常/3:不允许范围外打卡)")
    private String electronFence;

    @ApiModelProperty("下班打卡限制 (1:下班不需要打卡;2:下班需要打卡，且必须打上班卡才能打下班卡;3:下班需要打卡，无需打上班卡，就能打下班卡)")
    @SaturnColumn(description = "下班打卡限制 (1:下班不需要打卡;2:下班需要打卡，且必须打上班卡才能打下班卡;3:下班需要打卡，无需打上班卡，就能打下班卡)")
    private String gooffWork;

    @ApiModelProperty("考勤打卡记录表 考勤打卡记录表")
    @SaturnColumn(description = "考勤打卡记录表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaWorkSignRecordRespVo> sfaWorkSignRecordRespVos;

}