package com.biz.crm.nebular.sfa.worksignrule.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 考勤规则;考勤规则请求vo
 *
 * @author liuhongming
 * @date 2020-09-16 14:50:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkSignRuleReqVo", description = "考勤规则;考勤规则")
public class SfaWorkSignRuleReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("规则编码;规则编码")
    private String ruleCode;

    @ApiModelProperty("规则名称;规则名称")
    private String ruleName;

    @ApiModelProperty("规则类型;规则类型(1:固定时间上下班规则/2:自由时间上下班规则)")
    private String ruleType;

    @ApiModelProperty("电子围栏;电子围栏(1:允许范围外打卡，地点记录为异常/2:允许范围外打卡，地点记录为正常/3:不允许范围外打卡)")
    private String electronFence;

    @ApiModelProperty("工作日;(1:星期一;2:星期二;3:星期三;4:星期四;5:星期五;6:星期六;7:星期日)")
    private String workingDay;

    @ApiModelProperty("节假日;节假日(1：同步中国节假日节假日期间不用打卡)")
    private String holidayWhether;

    @ApiModelProperty("拍照打卡;拍照打卡(1:员工打卡时必须拍照)")
    private String wsrPhotograph;

    @ApiModelProperty("下班;(1:下班不需要打卡;2:下班需要打卡，且必须打上班卡才能打下班卡;3:下班需要打卡，无需打上班卡，就能打下班卡)")
    private String gooffWork;

    @ApiModelProperty("规则编码集合;规则编码集合")
    private List<String> ruleCodes;
    @ApiModelProperty("考勤规则-打卡人员包含")
    private List<SfaWorkSignPersonnelReqVo> personnelReqContainVos;
    @ApiModelProperty("考勤规则-打卡人员非包含")
    private List<SfaWorkSignPersonnelReqVo> personnelReqNonInclusionVos;
    @ApiModelProperty("考勤规则-打卡地点")
    private List<SfaWorkSignPlaceReqVo> sfaWorkSignPlaceReqVos;
    @ApiModelProperty("考勤规则-打卡时间")
    private List<SfaWorkSignTimeReqVo> sfaWorkSignTimeReqVos;
    @ApiModelProperty("考勤规则-特殊日期 必须打卡的日期")
    private List<SfaWorkSignSpecialReqVo> sfaWorkSignSpecialMustReqVos;
    @ApiModelProperty("考勤规则-特殊日期 不用打卡的日期")
    private List<SfaWorkSignSpecialReqVo> sfaWorkSignSpecialNotReqVos;


}