package com.biz.crm.nebular.mdm.customer;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import com.biz.crm.nebular.mdm.CrmTreeVo;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * 请求vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "MdmCustomerDockingReqVo", description = "客户信息：对接人")
@Accessors(chain = true)
public class MdmCustomerDockingReqVo extends CrmTreeVo {


    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("联系方式")
    private String contact;

    @ApiModelProperty("用户帐号")
    @NotBlank(message = "用户帐号不能为空")
    private String userAccount;

}