package com.biz.crm.nebular.mdm.dict.resp;

import com.biz.crm.nebular.mdm.PageVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * 字典明细项返回vo
 *
 * @author Tao.Chen
 * @date 2020-10-26 16:47:25
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "字典明细项")
@SaturnEntity(name = "EngineDictItemRespVo", description = "字典明细项")
public class EngineDictItemRespVo extends PageVo {

    @ApiModelProperty("字典明细的启用状态")
    @SaturnColumn(description = "字典明细的启用状态")
    private Boolean dictItemStatus;

    @ApiModelProperty("字典的名称")
    @SaturnColumn(description = "字典的名称")
    private String dictKey;

    @ApiModelProperty("字典的排序")
    @SaturnColumn(description = "字典的排序")
    private Integer dictSort;

    @ApiModelProperty("字典值")
    @SaturnColumn(description = "字典值")
    private String dictValue;

    @ApiModelProperty("对应字典")
    @SaturnColumn(description = "对应字典")
    private String dictEntityId;

    @ApiModelProperty("工程名")
    @SaturnColumn(description = "工程名")
    private String projectName;

    @ApiModelProperty("创建时间")
    @SaturnColumn(description = "创建时间")
    private Date createTime;

    @ApiModelProperty("字典描述")
    @SaturnColumn(description = "字典描述")
    private String dictDesc;

    @ApiModelProperty("上级字典ID")
    @SaturnColumn(description = "上级字典ID")
    private String parentId;

    @ApiModelProperty("扩展1")
    @SaturnColumn(description = "扩展1")
    private String ext1;

    @ApiModelProperty("扩展2")
    @SaturnColumn(description = "扩展2")
    private String ext2;

    @ApiModelProperty("扩展3")
    @SaturnColumn(description = "扩展3")
    private String ext3;

    @ApiModelProperty("扩展4")
    @SaturnColumn(description = "扩展4")
    private String ext4;

    @ApiModelProperty("扩展5")
    @SaturnColumn(description = "扩展5")
    private String ext5;

    @ApiModelProperty("扩展6")
    @SaturnColumn(description = "扩展6")
    private String ext6;

    @ApiModelProperty("扩展7")
    @SaturnColumn(description = "扩展7")
    private String ext7;

    @ApiModelProperty("扩展8")
    @SaturnColumn(description = "扩展8")
    private String ext8;

    @ApiModelProperty("扩展9")
    @SaturnColumn(description = "扩展9")
    private String ext9;

    @ApiModelProperty("扩展10")
    @SaturnColumn(description = "扩展10")
    private String ext10;

    @ApiModelProperty("对应字典CODE")
    @SaturnColumn(description = "对应字典CODE")
    private String dictEntityCode;

    @ApiModelProperty("字典层级")
    @SaturnColumn(description = "字典层级")
    private Integer dictLevel;

    @ApiModelProperty("子集")
    private List<EngineDictItemRespVo> children;

}