package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 描述业务系统中的岗位信息请求vo
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "EnginePositionReqVo", description = "描述业务系统中的岗位信息")
public class EnginePositionReqVo extends CrmTreeTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("岗位的父级ID")
    private String parentId;

    @ApiModelProperty("职级编码")
    private String positionLevelCode;

    @ApiModelProperty("")
    private String positionPrimary;

    @ApiModelProperty("用户帐号")
    private String userAccount;

    @ApiModelProperty("是否主职位:1是，0否")
    private Integer isPrimary;

    @ApiModelProperty("联合名称模糊查询字段，模糊查询职位名称和关联用户名称")
    private String unionNameQuery;

}