package com.biz.crm.nebular.sfa.visitstep.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 拜访步骤(库存盘点);返回vo
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访步骤(库存盘点);")
@SaturnEntity(name = "SfaVisitStepStockRespVo", description = "拜访步骤(库存盘点);")
public class SfaVisitStepStockRespVo extends CrmExtVo {

    @ApiModelProperty("库存盘点类型(备用涉及周盘、月盘、年盘)")
    @SaturnColumn(description = "库存盘点类型(备用涉及周盘、月盘、年盘)")
    private String stockType;

    @ApiModelProperty("拜访编码")
    @SaturnColumn(description = "拜访编码")
    private String visitId;

    @ApiModelProperty("网点id")
    @SaturnColumn(description = "网点id")
    private String clientId;

    @ApiModelProperty("网点编码")
    @SaturnColumn(description = "网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    @SaturnColumn(description = "网点名称")
    private String clientName;

    @ApiModelProperty("网点类型")
    @SaturnColumn(description = "网点类型")
    private String clientType;

    @ApiModelProperty("产品编码")
    @SaturnColumn(description = "产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    @SaturnColumn(description = "产品名称")
    private String productName;

    @ApiModelProperty("系列编码")
    @SaturnColumn(description = "系列编码")
    private String seriesCode;

    @ApiModelProperty("系列名称")
    @SaturnColumn(description = "系列名称")
    private String seriesName;

    @ApiModelProperty("数量")
    @SaturnColumn(description = "数量")
    private BigDecimal quantity;

    @ApiModelProperty("单位")
    @SaturnColumn(description = "单位")
    private String unit;


}