package com.biz.crm.nebular.sfa.worksignrule;

import com.biz.crm.nebular.mdm.CrmExtEditVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 考勤规则查询对象
 *
 * @author liuhongming
 * @date 2020-09-16 14:50:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaWorkSignRuleQueryReqVo", description = "考勤规则查询对象")
public class SfaWorkSignRuleVo extends CrmExtVo {


    @ApiModelProperty("规则编码;规则编码")
    @SaturnColumn(description = "考勤规则-规则编码")
    private String ruleCode;

    @ApiModelProperty("规则名称;规则名称")
    @SaturnColumn(description = "考勤规则-规则名称")
    private String ruleName;

    @ApiModelProperty("规则类型;规则类型(STATIC:固定时间上下班规则/FREE_TIME:自由时间上下班规则)")
    @SaturnColumn(description = "考勤规则-规则类型(STATIC:固定时间上下班规则/FREE_TIME:自由时间上下班规则)")
    private String ruleType;

    @ApiModelProperty("电子围栏;电子围栏(NONE:无电子围栏/OUT_SIGN_EX:允许范围外打卡，地点记录为异常/OUT_SIGN_OK:允许范围外打卡，地点记录为正常/NO_OUT_SIGN:不允许范围外打卡)")
    @SaturnColumn(description = "考勤规则-电子围栏(NONE:无电子围栏/OUT_SIGN_EX:允许范围外打卡，地点记录为异常/OUT_SIGN_OK:允许范围外打卡，地点记录为正常/NO_OUT_SIGN:不允许范围外打卡)")
    private String electronFence;

    @ApiModelProperty("工作日;(0:星期一;1:星期二;2:星期三;3:星期四;4:星期五;5:星期六;6:星期日)")
    @SaturnColumn(description = "考勤规则-(0:星期一;1:星期二;2:星期三;3:星期四;4:星期五;5:星期六;6:星期日)")
    private String workingDay;

    @ApiModelProperty("节假日;节假日(Y：同步中国节假日节假日期间不用打卡)")
    @SaturnColumn(description = "考勤规则-节假日(Y：同步中国节假日节假日期间不用打卡)")
    private String holidayWhether;

    @ApiModelProperty("拍照打卡;拍照打卡(Y:员工打卡时必须拍照)")
    @SaturnColumn(description = "考勤规则-拍照打卡(Y:员工打卡时必须拍照)")
    private String wsrPhotograph;

    @ApiModelProperty("下班打卡限制;(NO_SIGN:下班不需要打卡;GOTO_WORK_REQUIRED:下班需要打卡，且必须打上班卡才能打下班卡;GOTO_WORK_NO_REQUIRED:下班需要打卡，无需打上班卡，就能打下班卡)")
    @SaturnColumn(description = "下班打卡限制;(NO_SIGN:下班不需要打卡;GOTO_WORK_REQUIRED:下班需要打卡，且必须打上班卡才能打下班卡;GOTO_WORK_NO_REQUIRED:下班需要打卡，无需打上班卡，就能打下班卡)")
    private String gooffWorkSignAstrict;



}