package com.bizunited.platform.common.vo;

/**
 * @Project crm
 * @PackageName com.biz.crm.common
 * @ClassName FormInstanceUuidVo
 * @Author HuangLong
 * @Date 2020/9/1 11:00
 * @Description TODO
 */

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

/**
 * 各种VO层对象的定义中，只要属于静态表单模板的主业务模型，都要集成该类<br>
 * 这个父类中将会有一个formInstanceId字段，这个字段的值将在创建业务表单实例时，将会有表单引擎进行生成和绑定
 * @author yinwenjie
 */
public abstract class FormInstanceUuidVo extends UuidVo {

    /**
     *
     */
    private static final long serialVersionUID = -3454365056435428734L;
    /**
     * 业务表数据对应的表单实例编号
     */
    @SaturnColumn(description="表单实例编号" , nullable=false , length=256 , unique=true , insertable=true , updatable=false)
    private String formInstanceId;

    public String getFormInstanceId() {
        return formInstanceId;
    }

    public void setFormInstanceId(String formInstanceId) {
        this.formInstanceId = formInstanceId;
    }
}
