package com.biz.crm.nebular.mdm.product.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 商品所包含的物料销售公司
 *
 * @author zxw
 * @date 2020-10-20 11:03
 **/
@Data
@ApiModel(value = "商品信息返回VO")
@SaturnDomain(value = "mdmproductsalecompanyrespvo")
@SaturnEntity(name = "MdmProductSaleCompanyRespVo", description = "商品所包含的物料销售公司")
public class MdmProductSaleCompanyRespVo {

    @ApiModelProperty("商品编码")
    @SaturnColumn(description = "商品编码")
    private String productCode;

    @ApiModelProperty("销售公司编码")
    @SaturnColumn(description = "销售公司编码")
    private String saleCompanyCode;

    @ApiModelProperty("销售公司名称")
    @SaturnColumn(description = "销售公司名称")
    private String saleCompanyName;
}
