package com.biz.crm.nebular.mdm.userterminal;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Set;

import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;

/**
 * 请求vo
 *
 * @author zxw
 * @date 2020-09-29 15:27:25
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPositionTerminalReqVo", description = "")
public class MdmPositionTerminalReqVo extends PageVo {

    @ApiModelProperty("职位编码")
    @NotBlank(message = "职位编码不能为空")
    private String positionCode;

    @ApiModelProperty("终端编码集合")
    @NotEmpty(message = "终端编码集合不能为空")
    private Set<String> terminalCodeList;

}