package com.biz.crm.nebular.tpm.feebudget.resp;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 费用预算 返回vo
 *
 * @author huanglong
 * @date 2020-09-14 17:11:59
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用预算 ")
@SaturnEntity(name = "TpmFeeBudgetRespVo", description = "费用预算 ")
public class TpmFeeBudgetRespVo extends CrmExtVo {

    @ApiModelProperty("关联管控维度表id")
    @SaturnColumn(description = "关联管控维度表id")
    private String controlId;

    @ApiModelProperty("费用预算编码")
    @SaturnColumn(description = "费用预算编码")
    private String feeBudgetCode;

    @ApiModelProperty("费用预算类型(字典)")
    @SaturnColumn(description = "费用预算类型(字典)")
    private String feeBudgetType;

    @ApiModelProperty("费用预算类型名称")
    @SaturnColumn(description = "费用预算类型")
    private String feeBudgetTypeName;

    @ApiModelProperty("预算年份(字典)")
    @SaturnColumn(description = "预算年份(字典)")
    private String budgetYear;

    @ApiModelProperty("预算年份名称")
    @SaturnColumn(description = "预算年份")
    private String budgetYearName;

    @ApiModelProperty("预算季度(字典)")
    @SaturnColumn(description = "预算季度(字典)")
    private String budgetQuater;

    @ApiModelProperty("预算季度名称")
    @SaturnColumn(description = "预算季度")
    private String budgetQuaterName;

    @ApiModelProperty("预算月份(字典)")
    @SaturnColumn(description = "预算月份(字典)")
    private String budgetMonth;

    @ApiModelProperty("预算月份名称")
    @SaturnColumn(description = "预算月份")
    private String budgetMonthName;

    @ApiModelProperty("客户所属组织编码")
    @SaturnColumn(description = "客户所属组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户所属组织名称")
    @SaturnColumn(description = "客户所属组织名称")
    private String customerOrgName;

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("预算科目编码")
    @SaturnColumn(description = "预算科目编码")
    private String budgetSubjectsCode;

    @ApiModelProperty("预算科目名称")
    @SaturnColumn(description = "预算科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("产品层级编码")
    @SaturnColumn(description = "产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    @SaturnColumn(description = "产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品编码")
    @SaturnColumn(description = "产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    @SaturnColumn(description = "产品名称")
    private String productName;

    @ApiModelProperty("期初金额")
    @SaturnColumn(description = "期初金额")
    private BigDecimal initAmount;

    @ApiModelProperty("调整金额")
    @SaturnColumn(description = "调整金额")
    private BigDecimal adjustTotalAmount;

    @ApiModelProperty("调整后金额")
    @SaturnColumn(description = "调整后金额")
    private BigDecimal afterAdjustAmount;

    @ApiModelProperty("已使用金额")
    @SaturnColumn(description = "已使用金额")
    private BigDecimal usedAmount;

    @ApiModelProperty("当前余额")
    @SaturnColumn(description = "当前余额")
    private BigDecimal canUseAmount;

    @ApiModelProperty("企业组织编码")
    @SaturnColumn(description = "企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    @SaturnColumn(description = "企业组织名称")
    private String orgName;

    @ApiModelProperty("企业组织类型")
    @SaturnColumn(description = "企业组织类型")
    private String orgType;

    @ApiModelProperty("企业组织类型名称")
    @SaturnColumn(description = "企业组织类型名称")
    private String orgTypeName;

    @ApiModelProperty("渠道(字典)")
    @SaturnColumn(description = "渠道(字典)")
    private String channel;

    @ApiModelProperty("渠道名称")
    @SaturnColumn(description = "渠道名称")
    private String channelName;

    @ApiModelProperty("门店编码")
    @SaturnColumn(description = "门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    @SaturnColumn(description = "门店名称")
    private String terminalName;


    @ApiModelProperty("数量")
    @SaturnColumn(description = "数量")
    private Integer num;



    @ApiModelProperty("预算扣减顺序")
    @SaturnColumn(description = "预算扣减顺序")
    private Integer reduceOrder;

    @ApiModelProperty("预算扣减比例")
    @SaturnColumn(description = "预算扣减比例")
    private BigDecimal reduceRatio;

    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String actCode;

}