package com.biz.crm.nebular.mdm.humanarea;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 一个拥有权限信息的业务系统用户定义返回vo
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "一个拥有权限信息的业务系统用户定义")
@SaturnEntity(name = "EngineUserRespVo", description = "一个拥有权限信息的业务系统用户定义")
public class EngineUserRespVo extends CrmBaseVo {

    @ApiModelProperty("用户编码")
    @SaturnColumn(description = "用户编码")
    private String userCode;

    @ApiModelProperty("登录账号")
    @SaturnColumn(description = "登录账号")
    private String userAccount;

    @ApiModelProperty("性别.0保密，1男 2女")
    @SaturnColumn(description = "性别.0保密，1男 2女")
    private Integer gender;

    @ApiModelProperty("用户账号密码信息（经过加密的）")
    @SaturnColumn(description = "用户账号密码信息（经过加密的）")
    private String userPassword;

    @ApiModelProperty("人员主要联系电话(也可能会使用该信息登录)")
    @SaturnColumn(description = "人员主要联系电话(也可能会使用该信息登录)")
    private String userPhone;

    @ApiModelProperty("用户名")
    @SaturnColumn(description = "用户名")
    private String userName;

    @ApiModelProperty("用户类型")
    @SaturnColumn(description = "用户类型")
    private String userType;

    @ApiModelProperty("用户类型名称")
    @SaturnColumn(description = "用户类型名称")
    @CrmDict(typeCode = DictConstant.USER_TYPE,dictCodeField = "userType")
    private String userTypeName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String positionCode;

    @ApiModelProperty("职位")
    @SaturnColumn(description = "职位")
    private String positionName;

    @ApiModelProperty("职位级别编码")
    @SaturnColumn(description = "职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("职位级别")
    @SaturnColumn(description = "职位级别")
    private String positionLevelName;

    @ApiModelProperty("上级用户")
    @SaturnColumn(description = "上级用户")
    private String parentUserName;

    @ApiModelProperty("上级用户帐号")
    @SaturnColumn(description = "上级用户帐号")
    private String parentUserAccount;

    @ApiModelProperty("所属组织编码")
    @SaturnColumn(description = "所属组织编码")
    private String orgCode;

    @ApiModelProperty("所属组织")
    @SaturnColumn(description = "所属组织")
    private String orgName;

    @ApiModelProperty("关联客户编码")
    @SaturnColumn(description = "关联客户编码")
    private String customerCode;

    @ApiModelProperty("关联客户")
    @SaturnColumn(description = "关联客户")
    private String customerName;

    @ApiModelProperty("锁定状态")
    @SaturnColumn(description = "锁定状态")
    private String lockState;

    @ApiModelProperty("锁定状态")
    @SaturnColumn(description = "锁定状态")
    @CrmDict(typeCode = DictConstant.LOCK_STATE,dictCodeField = "lockState")
    private String lockStateName;

    @ApiModelProperty("token")
    @SaturnColumn(description = "token")
    private String token;

    @ApiModelProperty("权限角色编码")
    @SaturnColumn(description = "权限角色编码")
    private String roleCode;

    @ApiModelProperty("权限角色")
    @SaturnColumn(description = "权限角色")
    private String roleName;

    @ApiModelProperty("客户用户角色编码")
    @SaturnColumn(description = "客户用户角色编码")
    private String customerRoleCode;

    @ApiModelProperty("客户用户角色名称")
    @SaturnColumn(description = "客户用户角色名称")
    private String customerRoleName;

}