package com.biz.crm.nebular.sfa.worksign.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 请假申请 请求vo
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaLeaveReqVo", description = "请假申请 ")
public class SfaLeaveReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("请假类型 请假类型")
    private String leaveType;

    @ApiModelProperty("请假事由 请假事由")
    private String leaveReason;

    @ApiModelProperty("人员账号 人员账号")
    private String userName;

    @ApiModelProperty("人员姓名 人员姓名")
    private String realName;

    @ApiModelProperty("职位编码 职位编码")
    private String posCode;

    @ApiModelProperty("职位名称 职位名称")
    private String posName;

    @ApiModelProperty("所属组织编码 所属组织编码")
    private String orgCode;

    @ApiModelProperty("所属组织名称 所属组织名称")
    private String orgName;

    @ApiModelProperty("申请日期 申请日期(yyyy-MM-dd HH:mm:dd)")
    private String applicationDate;

    @ApiModelProperty("开始时间 开始时间(yyyy-MM-dd HH)")
    private String beginTime;

    @ApiModelProperty("结束时间 结束时间(yyyy-MM-dd HH)")
    private String endTime;

    @ApiModelProperty("审批状态 审批状态")
    private String bpmStatus;

}