package com.biz.crm.nebular.tpm.account.resp;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 费用上账货补产品表 返回vo
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用上账货补产品表 ")
@SaturnEntity(name = "TpmAccountProductRespVo", description = "费用上账货补产品表 ")
public class TpmAccountProductRespVo extends CrmExtVo {
    @ApiModelProperty("上账编码")
    @SaturnColumn(description = "上账编码")
    private String accountCode;

    @ApiModelProperty("分组id(标识同一次提交的数据)")
    private String groupId;

    @ApiModelProperty("货补产品编码")
    @SaturnColumn(description = "货补产品编码")
    private String productCode;

    @ApiModelProperty("货补产品名称")
    @SaturnColumn(description = "货补产品名称")
    private String productName;

}