package com.biz.crm.nebular.tpm.act.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.tpm.act.req
 * @ClassName ActDetailFeeShareVo
 * @Author HuangLong
 * @Date 2020/11/17 11:27
 * @Description 活动明细费用分摊请求,响应vo
 */
@Data
public class ActDetailFeeShareVo implements Serializable {
    private static final long serialVersionUID = 1708440745189351010L;


    @ApiModelProperty("执行开始日期")
    private String executeBeginDate;

    @ApiModelProperty("执行开始时间")
    private String executeBeginDateSecond;

    @ApiModelProperty("执行结束日期")
    private String executeEndDate;

    @ApiModelProperty("执行结束时间")
    private String executeEndDateSecond;

    @ApiModelProperty("费用所属年月")
    private String feeDateStr;

    @ApiModelProperty("分摊分组编码(未分摊为空)")
    private String feeShareGroupId;

    @ApiModelProperty("分摊金额")
    private BigDecimal feeShareAmount;

}
