package com.biz.crm.nebular.dms.companyinformation;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @Description: 公司资料主表
 * @Author: zhangyuzhu
 * @Date: 2020/9/10 14:46
 **/
//@Entity
//@Table(name = "dms_company_information")
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "公司资料主信息的vo")
@SaturnEntity(name = "CompanyInformationVo", description = "公司资料主信息")
@SaturnDomain(value = "companyinformation")
public class CompanyInformationVo extends CrmExtVo {

    @ApiModelProperty(value = "资料名称")
    @SaturnColumn(description = "资料名称")
    private String name;


    @ApiModelProperty(value = "资料类型")
    @SaturnColumn(description = "资料类型")
    private Integer type;

    /***/
    @ApiModelProperty(value = "文件信息")
    @SaturnColumn(description = "文件信息")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<CompanyInformationFileVo>  files;

    @ApiModelProperty(value = "范围信息（组织-包含）")
    @SaturnColumn(description = "范围信息（组织-包含）")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<CompanyInformationAreaVo>  orgs;

    @ApiModelProperty(value = "范围信息（组织-不包含）")
    @SaturnColumn(description = "范围信息（组织-不包含）")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<CompanyInformationAreaVo>  nonOrgs;

    @ApiModelProperty(value = "范围信息（客户-包含）")
    @SaturnColumn(description = "范围信息（客户-包含）")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<CompanyInformationAreaVo>  customers;

    @ApiModelProperty(value = "范围信息（客户-不包含）")
    @SaturnColumn(description = "范围信息（客户-不包含）")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<CompanyInformationAreaVo>  nonCustomers;
}
