package com.biz.crm.nebular.dms.promotion;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;



/**
 *
 * 计算规则脚本参数
 *  @author: luoqi
 *  @Date: 2020-10-29 14:08
 *  @version: V1.0
 *  @Description:
 */
@ApiModel("计算规则脚本参数")
@Data
public class CalculateRuleShellParam extends BasePromotionPolicyCalculateShellParam {
    //该商品购买数量
    @ApiModelProperty(value = "该商品购买数量")
    private BigDecimal productBuyNo;
    //该商品购买金额
    @ApiModelProperty(value = "该商品购买金额")
    private BigDecimal productBuyAmount;
    //政策阶梯列表
    @ApiModelProperty(value = "政策阶梯列表")
    private List<Map<String, Object>> ladderList;
    //条件规则脚本
    @ApiModelProperty(value = "条件规则脚本")
    private String conditionShellBody;
    //条件规则脚本名称(使用规则编码)
    @ApiModelProperty(value = "条件规则脚本名称(使用规则编码)")
    private String conditionShellName;
}
