package com.biz.crm.nebular.dms.promotion;


import com.biz.crm.nebular.mdm.CrmExtEditVo;
import com.biz.crm.util.CommonConstant;
import com.google.common.collect.Maps;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 订单商品政策规则配置信息查询参数
 *  @author: luoqi
 *  @Date: 2020-11-18 11:27
 *  @version: V1.0
 *  @Description:
 */
public class ConfigInfoQueryVo extends CrmExtEditVo {

    //客户编码
    @Getter
    @Setter
    private String custCode;

    //组织编码（销售区域）
    @Getter
    @Setter
    private String orgCode;

    //订单商品列表
    @Getter
    @Setter
    private List<ProductOrderInfo> orderProductInfos;
    
    /**
     *
     *  @author: luoqi
     *  @Date: 2020-11-19 11:28
     *  @version: V1.0
     *  @Description:
     */
    public static class ProductOrderInfo {
        //政策id
        @Getter
        @Setter
        private String promotionPolicyId;
        @Getter
        @Setter
        private String productCode;
        //本品购买总数量
        @Getter
        private BigDecimal productBuyNo;
        //本品购买总金额
        @Getter
        private BigDecimal productBuyAmount;



        public void setProductBuyNo(BigDecimal productBuyNo){
            this.productBuyNo = productBuyNo;
            this.productBuyMap.put(CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode(), this.productBuyNo);
        }
        public void setProductBuyAmount(BigDecimal productBuyAmount){
            this.productBuyAmount = productBuyAmount;
            this.productBuyMap.put(CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.AMOUNT.getItemCode(), this.productBuyAmount);
        }
        @Getter
        private Map<String, BigDecimal> productBuyMap = Maps.newHashMap();
    }
}
