package com.biz.crm.nebular.mdm.availablelistrule;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 可够清单规则购买范围
 * @Author: zhangyuzhu
 * @Date: 2020/9/24 16:59
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "可够清单规则购买范围信息的vo")
@SaturnEntity(name = "AvailableListRuleAreaVo", description = "可够清单规则购买范围信息")
public class AvailableListRuleAreaVo extends CrmExtVo {


    @ApiModelProperty(value = "规则编码")
    @SaturnColumn(description = "规则编码")
    private String ruleCode;

    @ApiModelProperty(value = "组织编码(包含客户和终端)")
    @SaturnColumn(description = "组织编码(包含客户和终端)")
    private String orgCode;

    @ApiModelProperty(value = "组织名称(包含客户和终端)")
    @SaturnColumn(description = "组织名称(包含客户和终端)")
    private String orgName;

    @ApiModelProperty(value = "客户编码")
    @SaturnColumn(description = "客户编码")
    private String cusCode;

    @ApiModelProperty(value = "客户名称")
    @SaturnColumn(description = "客户名称")
    private String cusName;

    @ApiModelProperty(value = "客户所属企业组织编码")
    @SaturnColumn(description = "客户所属企业组织编码")
    private String cusOrgCode;

    @ApiModelProperty(value = "客户所属企业组织名称")
    @SaturnColumn(description = "客户所属企业组织名称")
    private String cusOrgName;

    @ApiModelProperty(value = "客户所属渠道编码")
    @SaturnColumn(description = "客户所属渠道编码")
    private String cusChannelCode;

    @ApiModelProperty(value = "客户所属渠道名称")
    @SaturnColumn(description = "客户所属渠道名称")
    private String cusChannelName;

    @ApiModelProperty(value = "客户编码")
    @SaturnColumn(description = "客户编码")
    private String terminalCode;

    @ApiModelProperty(value = "客户名称")
    @SaturnColumn(description = "客户名称")
    private String terminalName;

    @ApiModelProperty(value = "客户所属企业组织编码")
    @SaturnColumn(description = "客户所属企业组织编码")
    private String terminalOrgCode;

    @ApiModelProperty(value = "客户所属企业组织名称")
    @SaturnColumn(description = "客户所属企业组织名称")
    private String terminalOrgName;

    @ApiModelProperty(value = "客户所属渠道编码")
    @SaturnColumn(description = "客户所属渠道编码")
    private String terminalChannelCode;

    @ApiModelProperty(value = "客户所属渠道名称")
    @SaturnColumn(description = "客户所属渠道名称")
    private String terminalChannelName;
}
