package com.biz.crm.nebular.mdm.constant;

/**
 * 字典常量
 *
 * @author zxw
 */
public interface DictConstant {

    /**
     * 销售公司
     */
    String SALE_COMPANY = "sale_company";

    /**
     * 客户组织层级
     */
    String CUS_ORG_LEVEL = "cus_org_level";

    /**
     * 客户组织类型
     */
    String CUS_ORG_TYPE = "cus_org_type";

    /**
     * 用户类型：u用户，c客户用户
     */
    String USER_TYPE = "user_type";

    /**
     * 操作类型n新建职位，h已有职位
     */
    String POSITION_OPERATION = "position_operation";

    /**
     * 主职位，y是n否
     */
    String POSITION_PRIMARY = "position_primary";

    /**
     * 权限对象
     */
    String PERMISSION_OBJ = "permission_obj";

    /**
     * 权限维度
     */
    String PERMISSION_DIMENSION = "permission_dimension";

    /**
     * 数据来源
     */
    String PERMISSION_RESOURCE = "permission_resource";

    /**
     * 组织层级
     */
    String MDM_ORG_LEVEL = "mdm_org_level";
    /**
     * 行政区域层级
     */
    String REGION_LEVEL = "region_level";

    /**
     * 物料基本单位
     **/
    String MATERIAL_BASE_UNIT = "material_base_unit";
    /**
     * 销售单位
     **/
    String MATERIAL_SALE_UNIT = "material_sale_unit";

    /**
     * 锁定状态
     * 003:锁定; 009:正常
     **/
    String LOCK_STATE = "lock_state";

    /**
     * 菜单模块
     */
    String FUNCTION_MODULE = "function_module";

    /**
     * 菜单类型
     */
    String FUNCTION_CONFIG = "function_config";

}
