package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 职位
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位响应")
@SaturnEntity(name = "EnginePositionRespVo", description = "职位响应")
public class EnginePositionRespVo extends CrmTreeTenVo {
    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String positionName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("岗位的父级ID")
    @SaturnColumn(description = "岗位的父级ID")
    private String parentId;

    @ApiModelProperty("职级编码")
    @SaturnColumn(description = "所属编码")
    private String positionLevelCode;

    @ApiModelProperty("是否主职位1是0否")
    @SaturnColumn(description = "是否主职位1是0否")
    private Integer isPrimary;

    @ApiModelProperty("用户帐号")
    @SaturnColumn(description = "用户帐号")
    private String userAccount;

    @ApiModelProperty("用户名称")
    @SaturnColumn(description = "用户名称")
    private String userName;

}