package com.biz.crm.nebular.mdm.org.resp;

import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 组织表返回vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "组织表")
@SaturnEntity(name = "MdmOrgRespVo", description = "组织表")
public class MdmOrgRespVo extends CrmTreeTenVo {
    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("组织类型")
    @SaturnColumn(description = "组织类型")
    private String orgType;

    @ApiModelProperty("组织描述")
    @SaturnColumn(description = "组织描述")
    private String orgDesc;

    @ApiModelProperty("上级组织编码")
    @SaturnColumn(description = "上级组织编码")
    private String parentCode;

    @ApiModelProperty("对应SAP组织编码")
    @SaturnColumn(description = "对应SAP组织编码")
    private String sapOrgCode;

    @ApiModelProperty("对应SAP组织编码利润中心编码")
    @SaturnColumn(description = "对应SAP组织编码利润中心编码")
    private String sapProfitOrgCode;

    @ApiModelProperty("对应SAP组织编码成本中心编码")
    @SaturnColumn(description = "对应SAP组织编码成本中心编码")
    private String sapCostOrgCode;

    @ApiModelProperty("上级组织名称")
    @SaturnColumn(description = "上级组织名称")
    private String parentName;

}