package com.biz.crm.nebular.mdm.orgregion.resp;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 组织和行政区域关联表返回vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 10:42:46
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "组织和行政区域关联表")
@SaturnEntity(name = "MdmOrgRegionRespVo", description = "组织和行政区域关联表")
public class MdmOrgRegionRespVo extends UuidVo {

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("省份编码")
    @SaturnColumn(description = "省份编码")
    private String provinceCode;

    @ApiModelProperty("省份")
    @SaturnColumn(description = "省份")
    private String provinceName;

    @ApiModelProperty("城市编码")
    @SaturnColumn(description = "城市编码")
    private String cityCode;

    @ApiModelProperty("城市")
    @SaturnColumn(description = "城市")
    private String cityName;

    @ApiModelProperty("区县编码")
    @SaturnColumn(description = "区县编码")
    private String districtCode;

    @ApiModelProperty("区县")
    @SaturnColumn(description = "区县")
    private String districtName;

    @ApiModelProperty("乡镇编码")
    @SaturnColumn(description = "乡镇编码")
    private String townshipCode;

    @ApiModelProperty("乡镇")
    @SaturnColumn(description = "乡镇")
    private String townshipName;

}