package com.biz.crm.nebular.mdm.pageconfig;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 字段配置返回vo
 *
 * @author zxw
 * @date 2020-11-21 12:19:06
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "字段配置")
@SaturnEntity(name = "MdmColumnConfigRespVo", description = "字段配置")
public class MdmColumnConfigRespVo extends CrmExtTenVo {

    @ApiModelProperty("菜单编码")
    @SaturnColumn(description = "菜单编码")
    private String functionCode;

    @ApiModelProperty("属性")
    @SaturnColumn(description = "属性")
    private String field;

    @ApiModelProperty("标签")
    @SaturnColumn(description = "标签")
    private String title;

    @ApiModelProperty("显示模式：true显示，false隐藏")
    @SaturnColumn(description = "显示模式：true显示，false隐藏")
    private Boolean visible;

    @ApiModelProperty("对齐方式")
    @SaturnColumn(description = "对齐方式")
    private String align;

    @ApiModelProperty("类型")
    @SaturnColumn(description = "类型")
    private String type;

    @ApiModelProperty("宽度")
    @SaturnColumn(description = "宽度")
    private String width;

    @ApiModelProperty("位置")
    @SaturnColumn(description = "位置")
    private String fixed;

    @ApiModelProperty("顺序")
    @SaturnColumn(description = "顺序")
    private String columnOrder;

    @ApiModelProperty("是否展示省略号true展示，false不展示")
    @SaturnColumn(description = "是否展示省略号true展示，false不展示")
    private Boolean showOverflow;

}