package com.biz.crm.nebular.mdm.pageconfig;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 表单配置请求vo
 *
 * @author zxw
 * @date 2020-11-21 15:51:27
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmFormConfigReqVo", description = "表单配置")
public class MdmFormConfigReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("菜单编码")
    private String functionCode;

    @ApiModelProperty("属性")
    private String field;

    @ApiModelProperty("标签")
    private String title;

    @ApiModelProperty("控件")
    private String className;

    @ApiModelProperty("值")
    private String value;

    @ApiModelProperty("刷新")
    private Boolean refresh;

    @ApiModelProperty("属性")
    private String props;

    @ApiModelProperty("事件")
    private String on;

    @ApiModelProperty("操作")
    private String options;

    @ApiModelProperty("校验")
    private String validate;

    @ApiModelProperty("显示模式：true显示，false隐藏")
    private Boolean visible;

    @ApiModelProperty("对齐方式")
    private String align;

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("宽度")
    private String width;

    @ApiModelProperty("位置")
    private String fixed;

    @ApiModelProperty("顺序")
    private String order;

    @ApiModelProperty("列样式")
    private String col;

}