package com.biz.crm.nebular.mdm.pageconfig;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 表单配置返回vo
 *
 * @author zxw
 * @date 2020-11-21 15:51:27
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "表单配置")
@SaturnEntity(name = "MdmFormConfigRespVo", description = "表单配置")
public class MdmFormConfigRespVo extends CrmExtTenVo {

    @ApiModelProperty("菜单编码")
    @SaturnColumn(description = "菜单编码")
    private String functionCode;

    @ApiModelProperty("属性")
    @SaturnColumn(description = "属性")
    private String field;

    @ApiModelProperty("标签")
    @SaturnColumn(description = "标签")
    private String title;

    @ApiModelProperty("控件")
    @SaturnColumn(description = "控件")
    private String className;

    @ApiModelProperty("值")
    @SaturnColumn(description = "值")
    private String value;

    @ApiModelProperty("刷新")
    @SaturnColumn(description = "刷新")
    private Boolean refresh;

    @ApiModelProperty("属性")
    @SaturnColumn(description = "属性")
    private String props;

    @ApiModelProperty("事件")
    @SaturnColumn(description = "事件")
    private String on;

    @ApiModelProperty("操作")
    @SaturnColumn(description = "操作")
    private String options;

    @ApiModelProperty("校验")
    @SaturnColumn(description = "校验")
    private String validate;

    @ApiModelProperty("显示模式：true显示，false隐藏")
    @SaturnColumn(description = "显示模式：true显示，false隐藏")
    private Boolean visible;

    @ApiModelProperty("对齐方式")
    @SaturnColumn(description = "对齐方式")
    private String align;

    @ApiModelProperty("类型")
    @SaturnColumn(description = "类型")
    private String type;

    @ApiModelProperty("宽度")
    @SaturnColumn(description = "宽度")
    private String width;

    @ApiModelProperty("位置")
    @SaturnColumn(description = "位置")
    private String fixed;

    @ApiModelProperty("顺序")
    @SaturnColumn(description = "顺序")
    private String order;

    @ApiModelProperty("列样式")
    @SaturnColumn(description = "列样式")
    private String col;

}