package com.biz.crm.nebular.mdm.permission;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 通用树响应
 *
 * @author zxw
 * @date 2020-10-27 13:48
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "BaseTreeRespVo")
@SaturnEntity(name = "BaseTreeRespVo", description = "通用树响应")
@AllArgsConstructor
@NoArgsConstructor
public class BaseTreeRespVo {

    @ApiModelProperty("编码")
    @SaturnColumn(description = "编码")
    private String code;

    @ApiModelProperty("名称")
    @SaturnColumn(description = "名称")
    private String name;

    @ApiModelProperty("id")
    @SaturnColumn(description = "id")
    private String id;

    @ApiModelProperty("上级id")
    @SaturnColumn(description = "上级id")
    private String parentId;

    @ApiModelProperty("上级code")
    @SaturnColumn(description = "上级code")
    private String parentCode;

    @ApiModelProperty("下级")
    @SaturnColumn(description = "下级")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<BaseTreeRespVo> children;

}
