package com.biz.crm.nebular.mdm.permission;

import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 数据权限请求vo
 *
 * @author zxw
 * @date 2020-10-26 12:09:31
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmDataPermissionReqVo", description = "数据权限")
public class MdmDataPermissionReqVo extends CrmTreeVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("角色编码")
    private String roleCode;

    @ApiModelProperty("角色编码集合")
    private List<String> roleCodeList;

    @ApiModelProperty("角色名称")
    private String roleName;

    @ApiModelProperty("列表配置编码")
    private String listConfigCode;

    @ApiModelProperty("权限对象编码")
    private String permissionObjCode;

    @ApiModelProperty("菜单编码")
    private String competenceCode;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("权限维度，数据字典：permission_dimension")
    private String permissionDimension;

    @ApiModelProperty("数据来源，数据字典：permission_resource")
    private String permissionResource;

    @ApiModelProperty("查询方式")
    private String permissionSearchType;

}