package com.biz.crm.nebular.mdm.positionlevel.resp;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 职位级别查看职位 返回vo
 *
 * @author Tao.Chen
 * @date 2020-10-22 10:56:51
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = " ")
@SaturnEntity(name = "MdmPositionLevelDetailRespVo", description = "职位级别查看职位")
public class MdmPositionLevelDetailRespVo extends CrmBaseVo {

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String positionName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("用户帐号")
    @SaturnColumn(description = "用户帐号")
    private String userAccount;

    @ApiModelProperty("用户姓名")
    @SaturnColumn(description = "用户姓名")
    private String userName;

}