package com.biz.crm.nebular.mdm.productlevel.resp;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 返回vo
 *
 * @author Liao.Hua
 * @date 2020-09-01 14:13:56
 */
@Data
@Table(name = "产品层级")
@SaturnDomain(value = "mdmproductlevelrespvo")
@SaturnEntity(name = "MdmProductLevelRespVo", description = "")
public class MdmProductLevelRespVo extends CrmBaseVo {
    @ApiModelProperty("层级等级查询用")
    @SaturnColumn(description = "层级等级查询用")
    private Integer levelNum;

    @ApiModelProperty("父级产品ID")
    @SaturnColumn(description = "父级产品ID")
    private String parentId;

    @ApiModelProperty("父级产品名称")
    @SaturnColumn(description = "父级产品名称")
    private String parentName;

    @ApiModelProperty("产品层级编码")
    @SaturnColumn(description = "产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    @SaturnColumn(description = "产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品层级类型")
    @SaturnColumn(description = "产品层级类型")
    private String productLevelType;

    @ApiModelProperty("产品层级类型名称")
    @SaturnColumn(description = "产品层级类型名称")
    @CrmDict(typeCode = "mdm_product_level_type",dictCodeField = "productLevelType")
    private String productLevelTypeName;

    @ApiModelProperty("规则code查询用")
    @SaturnColumn(description = "规则code查询用")
    private String ruleCode;

}