package com.biz.crm.nebular.mdm.terminal.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalContactRespVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalSupplyRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * 终端信息请求vo
 * @author Liao Hua
 * @date 2020/9/3 10:31 上午
 */
@Data
@ApiModel(value = "MdmTerminalReqVo", description = "终端信息请求vo")
public class MdmTerminalReqVo extends CrmBaseVo {

  @ApiModelProperty("根据公共树编码查询当前及下级组织终端")
  private String code;

  @ApiModelProperty("ID集合")
  private List<String> ids;

  @ApiModelProperty("终端编码")
  private String terminalCode;

  @ApiModelProperty("终端名称")
  private String terminalName;

  @ApiModelProperty("终端类型")
  private String terminalType;

  @ApiModelProperty("所属组织编码")
  private String orgCode;

  @ApiModelProperty("所属组织名称")
  private String orgName;

  @ApiModelProperty("客户组织编码")
  private String customerOrgCode;

  @ApiModelProperty("客户组织名称")
  private String customerOrgName;

  @ApiModelProperty("渠道")
  private String channel;

  @ApiModelProperty("营业执照法人姓名")
  private String licensePersonName;

  @ApiModelProperty("营业执照注册号")
  private String licenseRegisterNumber;

  @ApiModelProperty("营业执照企业名称")
  private String licenseFirmName;

  @ApiModelProperty("终端地址")
  private String terminalAddress;

  @ApiModelProperty("省编码")
  private String provinceCode;

  @ApiModelProperty("市编码")
  private String cityCode;

  @ApiModelProperty("区编码")
  private String districtCode;

  @ApiModelProperty("店招照片")
  private List<String> shopImagePath;

  @ApiModelProperty("营业执照照片")
  private List<String> licenseImagePath;

  @ApiModelProperty("组织编码集合")
  private List<String> orgCodeList;

  @ApiModelProperty("终端编码集合")
  private List<String> terminalCodeList;

  @ApiModelProperty("经度")
  @SaturnColumn(description = "经度")
  private String longitude;

  @ApiModelProperty("纬度")
  @SaturnColumn(description = "纬度")
  private String latitude;

  @ApiModelProperty("联系人列表")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
  @SaturnColumn(description = "联系人列表")
  private List<MdmTerminalContactReqVo> mdmTerminalContactVos;

  @ApiModelProperty("供应关系")
  @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
  @SaturnColumn(description = "供应关系")
  private List<MdmTerminalSupplyReqVo> mdmTerminalSupplyVos;
}
