package com.biz.crm.nebular.mdm.terminal.resp;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 终端图片返回vo
 *
 * @author zxw
 * @date 2020-11-23 11:53:06
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "终端图片")
@SaturnEntity(name = "MdmTerminalMediaRespVo", description = "终端图片")
public class MdmTerminalMediaRespVo {

    private String id;
    @ApiModelProperty("终端编码")
    @SaturnColumn(description = "终端编码")
    private String terminalCode;

    @ApiModelProperty("图片类型(0:营业执照照片,1:店招照片)")
    @SaturnColumn(description = "图片类型(0:营业执照照片,1:店招照片)")
    private String imageType;

    @ApiModelProperty("图片地址")
    @SaturnColumn(description = "图片地址")
    private String imagePath;

}