package com.biz.crm.nebular.mdm.terminal.resp;

import com.biz.crm.common.ParamCheck;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;

/**
 * 供货关系
 * @author liaohua
 * @date 2020/10/15 11:15 上午
 */
@NebulaExcelImport(startRow = 1)
public class MdmTerminalSupplyImportExcelVo {

  /**
   * 终端编码
   */
  @NebulaExcelColumn(order = 0, title = "终端编码")
  @ParamCheck(isNotNull = true,msg = "终端名称不能为空")
  private String terminalCode;

  /**
   * 职位编码
   */
  @NebulaExcelColumn(order = 1, title = "职位编码")
  @ParamCheck(isNotNull = true,msg = "职位编码")
  private String positionCode;

  /**
   * 客户编码
   */
  @NebulaExcelColumn(order = 2, title = "客户编码")
  @ParamCheck(isNotNull = true,msg = "客户编码")
  private String customerCode;

  public String getTerminalCode() {
    return terminalCode;
  }

  public void setTerminalCode(String terminalCode) {
    this.terminalCode = terminalCode;
  }

  public String getPositionCode() {
    return positionCode;
  }

  public void setPositionCode(String positionCode) {
    this.positionCode = positionCode;
  }

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  @Override
  public String toString() {
    return "MdmTerminalSupplyImportExcelVo{" +
        "terminalCode='" + terminalCode + '\'' +
        ", positionCode='" + positionCode + '\'' +
        ", customerCode='" + customerCode + '\'' +
        '}';
  }
}
