package com.biz.crm.nebular.mdm.terminal.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 终端供应关系
 * @author Liao Hua
 * @date 2020/9/5 3:46 下午
 */
@Data
@ApiModel(value = "终端供应关系")
@SaturnEntity(name = "MdmTerminalSupplyRespVo", description = "终端供应关系")
public class MdmTerminalSupplyRespVo extends CrmExtVo {

  @ApiModelProperty("终端编码")
  @SaturnColumn(description = "终端编码")
  private String terminalCode;

  @ApiModelProperty("职位编码")
  @SaturnColumn(description = "职位编码")
  private String positionCode;

  @ApiModelProperty("职位名称")
  @SaturnColumn(description = "职位名称")
  private String positionName;

  @ApiModelProperty("用户帐号")
  @SaturnColumn(description = "用户帐号")
  private String userAccount;

  @ApiModelProperty("用户名称")
  @SaturnColumn(description = "用户名称")
  private String userName;

  @ApiModelProperty("组织编码")
  @SaturnColumn(description = "组织编码")
  private String orgCode;

  @ApiModelProperty("组织名称")
  @SaturnColumn(description = "组织名称")
  private String orgName;

  @ApiModelProperty("上级客户编码")
  @SaturnColumn(description = "上级客户编码")
  private String customerCode;

  @ApiModelProperty("上级客户名称")
  @SaturnColumn(description = "上级客户名称")
  private String customerName;

  @ApiModelProperty("二批商客户编码")
  @SaturnColumn(description = "二批商客户编码")
  private String secondCustomerCode;

  @ApiModelProperty("二批商客户名称")
  @SaturnColumn(description = "二批商客户名称")
  private String secondCustomerName;

  @ApiModelProperty("商品列表")
  private List<MdmProductRespVo> mdmProductVos;


}
