package com.biz.crm.nebular.sfa.assistant.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskPictureReqVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 工作任务(接收) 返回vo
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "工作任务(接收) ")
@SaturnEntity(name = "SfaWorkTaskReceveRespVo", description = "工作任务(接收) ")
public class SfaWorkTaskReceveRespVo extends CrmExtVo {

    @ApiModelProperty("id")
    private String receveId;

    @ApiModelProperty("任务id")
    private String taskId;

    @ApiModelProperty("任务发送人")
    private String senderName;

    @ApiModelProperty("任务标题")
    private String taskTitle;

    @ApiModelProperty("截止时间")
    private String endDate;

    @ApiModelProperty("任务内容")
    private String content;

    @ApiModelProperty("创建时间")
    private String startDate;

    @ApiModelProperty("执行状态 0待执行 1已完成 2已回绝 3已过期")
    @CrmDict(typeCode = "execute_status",dictCodeField = "executeStatus")
    private String executeStatus;

    @ApiModelProperty("任务接收人")
    private String taskInPerson;

    @ApiModelProperty("照片列表")
    private List<SfaWorkTaskPictureRespVo> pictures;

}