package com.biz.crm.nebular.sfa.assistant.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 工作任务(发布) 返回vo
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "工作任务(发布) ")
@SaturnEntity(name = "SfaWorkTaskReleaseRespVo", description = "工作任务(发布) ")
public class SfaWorkTaskReleaseRespVo extends CrmExtVo {
    @ApiModelProperty("任务标题")
    private String taskTitle;

    @ApiModelProperty("截至时间")
    private String endDate;

    @ApiModelProperty("任务内容")
    private String content;

    @ApiModelProperty("任务进度 100以内数字 省略%")
    private String progress;

    @ApiModelProperty("任务状态 0未完成 1待执行 2已完成 3已拒绝 4已过期 5部分完成")
    @CrmDict(typeCode = "task_status",dictCodeField = "taskStatus")
    private String taskStatus;

    @ApiModelProperty("主id")
    private String taskId;

    @ApiModelProperty("执行人")
    private String executor;

    @ApiModelProperty("已完成数")
    private String quantityNum;

    @ApiModelProperty("总数")
    private String sumAll;



}