package com.biz.crm.nebular.sfa.visitinfo.req;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 拜访计划;请求vo
 *
 * @author Xiao
 * @date 2020-09-30 10:26:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitPlanInfoReqVo", description = "拜访计划;")
public class SfaVisitPlanInfoReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("拜访计划编码;拜访计划编码")
    private String visitPlanCode;

    @ApiModelProperty("人员ID;人员ID")
    private String visitUserId;

    @ApiModelProperty("人员账号;人员账号")
    private String visitUserName;

    @ApiModelProperty("人员姓名;人员姓名")
    private String visitRealName;

    @ApiModelProperty("人员职位ID;人员职位ID")
    private String visitPosId;

    @ApiModelProperty("人员职位编码;人员职位编码")
    private String visitPosCode;

    @ApiModelProperty("人员职位名称;人员职位名称")
    private String visitPosName;

    @ApiModelProperty("人员所属组织ID;人员所属组织ID")
    private String visitOrgId;

    @ApiModelProperty("人员所属组织编码;人员所属组织编码")
    private String visitOrgCode;

    @ApiModelProperty("人员所属组织名称;人员所属组织名称")
    private String visitOrgName;

    @ApiModelProperty("拜访日期;拜访日期yyyy-MM-dd")
    private String visitDate;

    @ApiModelProperty("拜访类型;拜访类型(临时拜访/计划拜访)")
    private String visitType;

    @ApiModelProperty("网点id;")
    private String clientId;

    @ApiModelProperty("网点编码;网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称;网点名称")
    private String clientName;

    @ApiModelProperty("网点类型;网点类型")
    private String clientType;

    @ApiModelProperty("网点地址;网点地址")
    private String clientAddress;

    @ApiModelProperty("网点联系人")
    private String clientContacts;

    @ApiModelProperty("网点图片")
    private String clientPhoto;

    @ApiModelProperty("网点电话 网点电话")
    private String clientPhone;

    @ApiModelProperty("经度;协访网点经度")
    private BigDecimal longitude;

    @ApiModelProperty("纬度;协访网点纬度")
    private BigDecimal latitude;

    @ApiModelProperty("距离hash值;协访网点hash值")
    private String geohash;

    @ApiModelProperty("状态;拜访状态")
    private String visitStatus;

    @ApiModelProperty("拜访时间：拜访开始时间")
    private String startVisitDate;

    @ApiModelProperty("拜访时间：拜访结束时间")
    private String endVisitDate;

    @ApiModelProperty("拜访人员组织编码")
    private List<String> visitOrgCodeList;

}